# 导入相关函数

> 导入用于将用户本地的excel文件读取出来并解析，需要使用到 Blob 对象中的一些方法，暂时无法兼容 IE11及以下的浏览器，仅支持 Edge、Firefox、Chrome等现代浏览器

#### importExcel参数配置

> 核心方法，用于读取用户选择的Excel信息，文件读取基于 FileReader，所以对浏览器版本要求较高

| 参数名称 | 描述                                                         | 默认值    |
| -------- | ------------------------------------------------------------ | --------- |
| files    | 上传文件DOM对象的 files 属性                                 | undefined |
| opt      | 导出参数配置，详见下方描述                                   | undefined |
| callback | 完全读取完毕的回调函数，传入一个参数「data」表示所有数据的集合 | undefined |

##### opt参数配置

| 参数名称 | 描述                                                         | 默认值 |
| -------- | ------------------------------------------------------------ | ------ |
| header   | 导入参数的headers，支持"A"、1等，[详见XLSX官方文档](https://github.com/SheetJS/js-xlsx#json) | A      |
| range    | 读取的范围，支持数字、字符等，[详见XLSX官方文档](https://github.com/SheetJS/js-xlsx#json) | null   |
| fields   | 可以在读取的过程中进行数据梳理，参数意义请参见「filterExportData参数配置」 | null   |

> 由于处理过程中会抛出一些异常，所以请使用 try{}catch(e){}接收并提示用户！
>
> 如果对导出数据格式的键不满意，可以有两种方式梳理：
>
> 1. 调用 filterImportData(data, fields)
> 2. 直接在 importExcel() 的 opt 配置中进行数据梳理

#### filterImportData参数配置

> 梳理导出的数据，包括字段排序和多余数据过滤，与 importExcel 的 field 字段含义一致

| 参数名称 | 描述                                                         | 默认值    |
| -------- | ------------------------------------------------------------ | --------- |
| data     | 导入的数据（文件维度）                                       | undefined |
| fields   | 可以在读取的过程中进行数据梳理，参数意义请参见「filterExportData参数配置」 | undefined |

#### 导入调用样例

具体亦可访问 [http://excel.wj2015.com](http://excel.wj2015.com) 在线体验

```javascript
$(function(){
    // 监听上传文件的事件
    $('#LAY-excel-import-excel').change(function(e) {
        var files = e.target.files;
        try {
            // 方式一：先读取数据，后梳理数据
            excel.importExcel(files, {}, function(data) {
                console.log(data);
                data = excel.filterImportData(data, {
                    'id': 'A'
                    ,'username': 'B'
                    ,'experience': 'C'
                    ,'sex': 'D'
                    ,'score': 'E'
                    ,'city': 'F'
                    ,'classify': 'G'
                    ,'wealth': 'H'
                    ,'sign': 'I'
                })
                console.log(data);
            });
            // 方式二：可以在读取过程中梳理数据
            excel.importExcel(files, {
                fields: {
                    'id': 'A'
                    ,'username': 'B'
                    ,'experience': 'C'
                    ,'sex': 'D'
                    ,'score': 'E'
                    ,'city': 'F'
                    ,'classify': 'G'
                    ,'wealth': 'H'
                    ,'sign': 'I'
                }
            }, function(data) {
                console.log(data);
            });
        } catch (e) {
            layer.alert(e.message);
        }
    });
});
```

#### 