# 样式设置相关函数

> 样式设置包括，给表格设置边框，添加背景色，改字号，文字局中，设置行高列宽，合并单元格等功能



#### setExportCellStyle参数配置

> 辅助方法：为 sheet 级别的数据批量设置单元格属性

| 参数名称 | 描述                                                         | 默认值                   |
| -------- | ------------------------------------------------------------ | ------------------------ |
| data     | sheet级别的数据                                              |                          |
| range    | 范围字符串，比如`" A1:C12"`表示开始位置默认 A1，结束位置C12  | 数据范围内左上角到右下角 |
| config   | 批量设置的单元格属性，会与之前的样式合并                     |                          |
| filter   | 回调函数，传递函数生效，返回值作为新的值（可用于过滤、规则替换样式等骚操作）**『非必填参数』** |                          |

##### filter入参列表

> 此参数选填，如果不传入则直接按照规则覆盖

| 参数名称   | 描述                                     |
| ---------- | ---------------------------------------- |
| cell       | 原有单元格数据                           |
| newCell    | 根据批量设置规则自动生成样式的单元格数据 |
| row        | 所在行数据                               |
| config     | 传入的配置                               |
| currentCol | 当前列索引                               |
| fieldKey   | 当前字段key                              |

##### 调用样例(更多用法可参考 index.js 中的样例)

```javascript
// 1. 假设的梳理后的后台的数据(省略filter函数梳理)
var data = [
    { username: '520',sex: '男', city: 'J', 'score': 100, 'start': '2019-03-11' },
    { username: '520',sex: '女', city: 'X', 'score': 100, 'start': '2019-03-11' },
    { username: '520',sex: '男', city: '上海', 'score': 100, 'start': '2019-03-11' }
];
// 2. 调用设置样式的函数，传入设置的范围，支持回调
excel.setExportCellStyle(data, 'A1:C3', {
    s: {
        fill: { bgColor: { indexed: 64 }, fgColor: { rgb: "FF0000" } },
        alignment: {
            horizontal: 'center',
            vertical: 'center'
        }
    }
}, function(cell, newCell, row, config, currentRow, currentCol, fieldKey) {
    // 回调参数，cell:原有数据，newCell:根据批量设置规则自动生成的样式，row:所在行数据，config:传入的配置,currentRow:当前行索引,currentCol:当前列索引，fieldKey:当前字段索引
    return ((currentRow + currentCol) % 2 === 0) ? newCell : cell;// 隔行隔列上色
} );
// 3. 导出数据
excel.exportExcel(data, '批量设置样式.xlsx', 'xlsx');
```

#### setRoundBorder参数配置

> 辅助方法：设置范围内环绕的边框

| 参数名称 | 描述                                                         | 默认值                                        |
| -------- | ------------------------------------------------------------ | --------------------------------------------- |
| data     | Sheet级别的数据                                              | []                                            |
| range    | 范围字符串，如 A1:C12，默认从左上角到右下角                  | "A1:C12"                                      |
| config   | border 上下左右属性配置信息（对角线的三个属性被下放到left/right/top/bottom下） | {top: {xxx}, bottom: {}, left: {}, right: {}} |

##### 调用样例

```javascript
LAY_EXCEL.setRoundBorder(list, 'A1:C2', {
    top: {style: 'thick', color: {rgb: 'FFFF0000'}},
    bottom: {style: 'thick', color: {rgb: 'FFFF0000'}},
    left: {style: 'thick', color: {rgb: 'FFFF0000'}},
    right: {style: 'thick', color: {rgb: 'FFFF0000'}}
});
```

#### makeMergeConfig参数配置

> 辅助方法：用于生成合并表格的配置项，注意需要传入到 exportExcel 的 opt.extend['!merge'] 中

| 参数名称 | 描述     | 默认值 |
| -------- | -------- | ------ |
| origin   | 二维数组 | null   |

##### origin数据样例

> 表示合并 A1~E1 行，并且合并 A2~D4行

```javascript
var mergeConf = excel.makeMergeConfig([
    ['A1', 'E1'],
    ['A2', 'D4']
]);
excel.exportExcel({
    sheet1: data
}, '测试导出复杂表头.xlsx', 'xlsx', {
    extend: {
        // 复杂表头合并[A1,E1][A2, D4]
        '!merges': mergeConf
    }
});
```

##### 调用样例

请见下方『使用方法』

#### makeColConfig参数配置

> 辅助方法：生成列宽配置，返回结果需放置于opt.extend['!cols']中

| 参数名称   | 描述                                                  | 默认值 |
| ---------- | ----------------------------------------------------- | ------ |
| data       | 一个对象，对象的key代表列（如：ABCDE），value代表宽度 | null   |
| defaultNum | 渲染过程中未指定单元格的默认宽度                      | 60     |

##### 使用样例

> key表示列，value表示宽，剩余宽度取默认值，特别注意要放在 opt.extend['!cols'] 中

```javascript
// 意思是：A列40px，B列60px(默认)，C列120px，D、E、F等均未定义
var colConf = excel.makeColConfig({
    'A': 40,
    'C': 120
}, 80);
excel.exportExcel({
    sheet1: data
}, '测试导出复杂表头.xlsx', 'xlsx', {
    extend: {
        '!cols': colConf
    }
});
```

#### makeRowConfig参数配置

> 辅助方法：生成列宽配置，返回结果需放置于opt.extend['!rows']中

| 参数名称   | 描述                                                         | 默认值 |
| ---------- | ------------------------------------------------------------ | ------ |
| data       | 一个对象，对象的key代表从1开始的行（如：1234），value代表高度 | null   |
| defaultNum | 渲染过程中未指定单元格的默认宽度                             | 60     |

##### 使用样例

> key表示行，value表示高度，剩余高度取默认值，特别注意要放在 opt.extend['!rows'] 中

```javascript
// 意思是：1行40px，2行60px(默认)，3行120px，4/5/6/7等行均未定义
var rowConf = excel.makeRowConfig({
    1: 40,
    3: 120
}, 80);
excel.exportExcel({
    sheet1: data
}, '测试导出复杂表头.xlsx', 'xlsx', {
    extend: {
        '!rows': rowConf
    }
});
```

