# 参与开发

本篇是给有想法参与本项目的童鞋们准备的，可以从三个方面参与本项目，PR通过后根据群规会赠送交流群管理员一枚~先到先得，送完为止，O(∩_∩)O

## 需要预先了解的知识

Git 基础，HTML 以及 JS，[Github 如何提交一个 Pull Request](https://qq52o.me/2503.html) 等

提交Demo如上知识已经可以了

如果参与开发插件功能，可能还需要了解 npm包管理工具、Grunt 压缩打包工具、XLSX.JS 的使用方法

## 如何提交一个Demo？

Demo的内容可以是 具体的使用场景、使用过程中踩过的坑 等，比如 数据量大的时候，实现一个带进度条的分段导出，比如数据量特别大的时候，使用压缩算法优化传输效率等。

**提交文件中不能有后端脚本，但允许在Demo页面中展示出来后端关键代码**，通过 AJAX 返回数据时可以直接用 `data.json` 等方式传输。

提交PR后可以在群里或邮件与我沟通，审查后会并入代码库并补充文档信息。

## 如何修改插件？

#### 熟悉一下目录结构

`src` 目录下的文件是源码文件，最主要的逻辑就在 `src/excel.js` 中，不过只改动这个是不行的，因为仅有插件逻辑无法实现所有的功能，所以需要通过打包工具把依赖的 `xlsx.js`、`jszip.js`、`FileSaver.js` 等打包到一起，生成文件到 `layui_exts/excel.js` 以及压缩版本 `layui_exts/excel.min.js`

#### 安装开发工具

打包工具使用的是 grunt，这个工具使用 npm包管理工具安装，所以需要先安装 npm

npm 可以通过安装 Node.js 的方式顺便安装上，Node 下载地址：[https://nodejs.org/en/download/](https://nodejs.org/en/download/)

更加详细的介绍可以看这个地方：[https://www.runoob.com/nodejs/nodejs-install-setup.html](https://www.runoob.com/nodejs/nodejs-install-setup.html)、[https://www.runoob.com/nodejs/nodejs-npm.html](https://www.runoob.com/nodejs/nodejs-npm.html)

安装完毕后在项目目录下执行 `npm install` 安装依赖即可，`grunt` 是一个全局命令，需要用 `npm install -g grunt` 安装，用于打包文件

#### 修改源码文件并重新打包

逻辑均在 `src/excel.js` 中，一般开发就是新增方法或者修改其中某个方法即可

开发完毕后，执行 `grunt` 命令，生成打包文件即可

```shell
$ grunt
Running "concat:dist" (concat) task

Running "uglify:build" (uglify) task

Done, without errors.
```

最后提交到版本库，Github 提一个 PR 即可

## 如何修改文档？

目前文档由 gitbook 编写，如果小幅度修改无需预览的话，可以直接修改 markdown 文件，如果需要预览文档样式，则需要安装 gitbook 工具

#### 安装gitbook

使用 -g 表示全局安装，安装完毕后全局区出现可执行脚本 `gitbook`，使用 `gitbook -V` 查看版本信息

```shell
$ npm install gitbook-cli -g
$ gitbook -V
CLI version: 2.3.2
GitBook version: 3.2.3
```

PS:第一次执行 gitbook -V 会安装GitBook ，如果没有梯子等待时间超长

更多 GitBook 上手请见博客：[https://blog.csdn.net/lu_embedded/article/details/81100704](https://blog.csdn.net/lu_embedded/article/details/81100704)

#### 生成文档

执行 `gitbook build`，会生成 `_book` 目录，这个目录不会提交到 git 上，通过浏览器打开里边的 `_book/index.html` 即可预览文档效果。

```shell
$ gitbook.cmd build
info: 7 plugins are installed
info: 6 explicitly listed
info: loading plugin "highlight"... OK
info: loading plugin "search"... OK
info: loading plugin "lunr"... OK
info: loading plugin "sharing"... OK
info: loading plugin "fontsettings"... OK
info: loading plugin "theme-default"... OK
info: found 13 pages
info: found 154 asset files
info: >> generation finished with success in 2.4s !
```

