# 常见问题

> 本篇主要记录交流过程中遇到的高频问题，如果遇到问题请先阅读此文档，然后再向群内提问

### 如何提问？

开源这个插件以来，遇到了很多群友提出的各种各样的问题，碰到的提问千奇百怪，有些是不看文档的伸手党，有些是简短一句话“程序跑不起来，大佬求帮忙！”，还有问个问题啪啪啪十几条消息就过来了，更有甚者还有在群里说“大佬在么？”

遇到这种问题，我不是诸葛亮算不出来到底是哪个地方有问题，像挤牙膏一样一点点问清楚也特别耽搁时间。如果手里头不忙的时候，我会引导一下，让他们把 **问题截图、代码、入参出参** 群里发一下，如果手里事情特别多就搁置着了，有时候群内管理或者群友看到了会帮着回复下（PS:非常感谢勤劳的管理和活跃的群友们）。

所以，群里提问可以附上  **问题截图、代码、入参出参** ，还可以附上你对这个问题的思考，有利于问题定位，提高解决问题的效率。

关于提问，有一篇张鑫旭大神写的文章推荐：[https://www.zhangxinxu.com/wordpress/2015/05/how-to-ask-web-front-question/?utm_source=caibaojian.com](https://www.zhangxinxu.com/wordpress/2015/05/how-to-ask-web-front-question/?utm_source=caibaojian.com)

## 综合问题

### 为什么DEMO放到本地无法使用？

预览代码需要部署在本地服务器下，因为代码内部通过AJAX获取数据，双击打开的页面无法异步获取需要导出的数据

### 如何在非Layui的环境下使用？

插件编写之初，用了一些 JQuery 的辅助方法没有剔除，所以至少需要加载 JQuery 才能使用本插件，然后再通过 Script 标签加载 layui_exts/excel.min.js，随后使用全局变量 LAY_EXCEL 调用函数

如果不知道咋用，记着直接 Script 引入文件最简单了。

```html
<html lang="en">
    <head>
      <meta charset="UTF-8">
      <title>非LAYUI加载</title>
      <!--先加载jquery-->
      <script src="https://cdn.bootcss.com/jquery/1.12.4/jquery.min.js"></script>
      <!--再加载插件-->
      <script src="../../layui_exts/excel.js"></script>
      <script>
          LAY_EXCEL.exportExcel([['Hello', 'World', '!']], 'hello.xlsx', 'xlsx')
      </script>
    </head>
    <body>
    </body>
</html>
```

可参见 Demo: [http://excel.wj2015.com/demos/noLayui/index.html](http://excel.wj2015.com/demos/noLayui/index.html)

## 导出问题

### 我的页面无法导出，并且报错 XLSX is not defined?

首先检查一下，插件文件是 `layui_exts/excel.js` 不是 `src/excel.js`，后者是源码，需要打包好 XLSX.JS FileSaver.js 等后才能正常使用。

也有可能是插件冲突，之前仅遇到过一次群友由于某个 JS 文件与 XLSX.JS 中 XLSX 的声明逻辑冲突。

### 为什么我的页面无法导出，并且没有报错？

遇到这个问题，可以根据如下步骤排查

- 是否是 IFRAME 内的导出
  - 在解决问题的过程中，看到一个项目用的 iframe 版的 layuiadmin，死活导不出来，最后通过调用父页面的导出插件解决了问题
  - 注：不能直接在IFRAME里边直接调用导出方法，因为浏览器会限制这种导出行为，如有遇到此类情况，可使用 parent.layui.excel.exportExcel() 的方式调用父级页面函数以避免这个问题（父页面需要先加载插件）
  - 可参见Demo：[http://excel.wj2015.com/demos/iframeExport/index.html](http://excel.wj2015.com/demos/iframeExport/index.html)
- 是不是重复加载了插件，比如 FileSaver 等
  - 这个是群友反馈的，说是之前引入了一个 PDF 导出插件，去掉引用就好了。
  - PS：可以依次去除依赖，以定位是哪个依赖冲突，如果能移除则移除掉，不能移除就需要查看源码打断点分析了

### 我想指定导出文件的下载路径，应该怎么做？

下载路径选择是浏览器自带的功能，我们只能定义下载的文件名。

### 插件支持移动端导出么？

可以去 [http://excel.wj2015.com](http://excel.wj2015.com) 试一下，我个人试下来，下载文件名是一个乱码，重命名为 xxx.xlsx 后可以打开，体验不大好，还没找到解决办法。

### 插件支持导入导出图片么？

还没有捯饬出来，导出图片可以使用 XLSX.JS 的富文本参数，但是尝试失败了，需求顺延中，如果有人试出来了，还请告诉我~

### 我该如何导出边框？

请查看[『样式设置专区』](./样式设置专区.html) 以及 [设置环绕边框辅助函数](./函数列表/样式设置相关函数.md#setroundborder参数配置)

### 为什么我的导出数据错位？

这种问题很大概率是表头与数据域不一致导致的，比如现在有如下数据

```javascript
// 纯数据
var data = [
    {name: 'xxx', sex: '222'}
];
// unshift 加入表头
data.unshift({age: '年龄', name: '姓名', sex: '性别'})
// 那么 data 如下：
// [{age: '年龄', name: '姓名', sex: '性别'}, {name: 'xxx', sex: 222}]
// 导出来的数据就会有三列，与纯数据的列不一致
```

解决方法，1. `unshift` 加入表头的字段顺序与纯数据的字段顺序一致，2. 用 `filterExportData` 函数梳理最终结果

### 导出能不能加一个进度条？

如果是分段获取数据，可以根据 当前页/总页数 做一个进度条，一旦进入导出流程，就由 XLSX.JS 控制了，暂时还无法做到进度条。

### 如何设置样式？

可以去 [样式专区](./样式设置专区.html) 查看相关使用方法。

### 能不能实现这样/那样的表头？

excel 里边能通过合并单元格做出来的样式都可以的，一般遵循如下步骤

- 将想要实现的表头在 excel 中通过合并单元格，加样式等形式画出来
- 将合并取消掉，剩下的就是想实现的表格的数据结构
- 在 unshift 表头的时候，每一行每个单元格与 excel 中的结构对应
- 有哪些单元格合并了，哪些加样式了，在代码中通过辅助函数表现出来即可
- Demo 中『导出复杂表头』可以给你一些参考：[http://excel.wj2015.com](http://excel.wj2015.com)

## 导入问题

### 我想获取用户上传文件的路径，应该怎么做？

骚年，想太多了，浏览器不会把路径给你的，前端仅能通过 HTML5 的 FileReader 获取到文件内容，File 对象的 name 参数也只是文件名称罢了。

### 导入怎么支持IE11？

之前倒腾过一次，没弄出来，导入需要用到 Blob 以及一些辅助方法(readAsBinaryString等)，导致导入的兼容性不如导出。

## 提效建议：

> 数据规模：前端导出**纯数据 9列10w** 的数据量需要 **7秒左右**的时间，**30W数据占用1.8G，耗时24秒**，普通电脑**最多能导出50w数据，耗时45秒**，文件大小173M，提示内存超限

- 如果数据量比较大，**并且不涉及样式**，最好直接转换为纯数组+CSV的导出，可以省去 filterExportData 和 组装样式的时间和内存（PS：效率提升不算太大，30W数据能提速2s左右，资源主要消耗在调用 XLSX.js之后）
- 一般 exportExcel 会放在 $.ajax() 等异步调用中，如果有需要在点击后纯前端生成Excel，可以使用 async、setTimeout等方式实现异步导出，否则会阻塞主进程。