# 样式设置专区

> 此地仅做对象属性介绍，更多样式设置的函数请查看 『[样式设置相关函数](./函数列表/样式设置相关函数.html)』

#### 属性支持的单元格样式

| 样式属性  | 子属性       | 取值                                                         |
| :-------- | :----------- | :----------------------------------------------------------- |
| fill      | patternType  | `"solid"` or `"none"`                                        |
|           | fgColor      | `COLOR_SPEC`                                                 |
|           | bgColor      | `COLOR_SPEC`                                                 |
| font      | name         | `"Calibri"` // 默认字体                                      |
|           | sz           | `"11"` // 字体大小                                           |
|           | color        | `COLOR_SPEC`                                                 |
|           | bold         | `true` or `false`                                            |
|           | underline    | `true` or `false`                                            |
|           | italic       | `true` or `false`                                            |
|           | strike       | `true` or `false`                                            |
|           | outline      | `true` or `false`                                            |
|           | shadow       | `true` or `false`                                            |
|           | vertAlign    | `true` or `false`                                            |
| numFmt    |              | `"0"`  // 内置格式的整数索引，请参见StyleBuilder.SSF属性     |
|           |              | `"0.00%"` // 匹配内置格式的字符串，请参阅StyleBuilder.SSF    |
|           |              | `"0.0%"`  // 指定自定义格式的字符串                          |
|           |              | `"0.00%;\\(0.00%\\);\\-;@"` // 指定自定义格式的字符串，转义特殊字符 |
|           |              | `"m/dd/yy"` // 使用Excel的格式表示法字符串日期格式           |
| alignment | vertical     | `"bottom"` or `"center"` or `"top"`                          |
|           | horizontal   | `"left"` or `"center"` or `"right"`                          |
|           | wrapText     | `true ` or ` false` // 自动换行                              |
|           | readingOrder | `2` // 从右到左                                              |
|           | textRotation | 从 `0` 到 `180` 或者 `255` (默认为 `0`)                      |
|           |              | `90` 旋转90度                                                |
|           |              | `45` 旋转45度                                                |
|           |              | `135` 反向旋转45度                                           |
|           |              | `180` 旋转180度                                              |
|           |              | `255` 特殊：垂直对齐                                         |
| border    | top          | `{ style: BORDER_STYLE, color: COLOR_SPEC }`                 |
|           | bottom       | `{ style: BORDER_STYLE, color: COLOR_SPEC }`                 |
|           | left         | `{ style: BORDER_STYLE, color: COLOR_SPEC }`                 |
|           | right        | `{ style: BORDER_STYLE, color: COLOR_SPEC }`                 |
|           | diagonal     | `{ style: BORDER_STYLE, color: COLOR_SPEC }`                 |
|           | diagonalUp   | `true` or `false`                                            |
|           | diagonalDown | `true` or `false`                                            |

**COLOR_SPEC**: 可以设置在 `fill`, `font`, 和 `border` 属性中，是一个对象:

- `{ auto: 1}` 指定自动值（楼主认为，应该是默认为白色的意思）
- `{ rgb: "FFFFAA00" }` 指定16进制 ARGB 的值（PS:ARGB，前两个16进制是透明度，比如不透明红色：FFFF0000）
- `{ theme: "1", tint: "-0.25"}` 指定主题颜色和色调值的整数索引（默认值为0）（PS：楼主也明白嘛意思）
- `{ indexed: 64}` 是 `fill.bgColor`属性的默认值，看着应该像索引之类的

**BORDER_STYLE**: 边框支持以下几种样式:

- `thin`(细边框)
- `medium`(中等)
- `thick`(厚)
- `dotted`(点线)
- `hair`(毛)
- `dashed`(虚线)
- `mediumDashed`(中等宽度虚线)
- `dashDot`( 点)
- `mediumDashDot`(中等宽度点)
- `dashDotDot`(虚线带点)
- `mediumDashDotDot`(中等虚线带点)
- `slantDashDot`(倾斜虚线点--楼主也没明白啥意思╮(╯▽╰)╭)

##### 合并区域边框

合并区域的边框是为合并区域内的每个单元格指定的。因此，要将框边框应用于3x3单元格的合并区域，需要为八个不同的单元格指定边框样式：

- 左边三个单元格的左边框,
- 右侧三个单元格的右边框
- 顶部单元格的顶部边框
- 左侧单元格的底部边框
